      PROGRAM TARSOX_SEL
C===================================================================
C===================================================================
C     Program for selecting TARSO models or TARSC models from a 
C     PREDEFINED SUBSET of candidate models. The threshold values  
C     are either USER-SUPPLIED or automatically selected.
C     The delays are USER-SUPPLIED (the program searches the best 
C     threshold values and AR-orders and lags for each delay).
C     Thresholds are allowed in the X variable only (= output variable).
C     Thresholds are searched at intervals of 1 cm in the output variable.
C     Version made by Martin Knotters, Spring 1997.
C
C Purpose: 
C
C       Model selection, using the Akaike Information Criterion (AIC), 
C       a corrected AIC (AICc, Hurvich and Tsai, 1991) or the
C       Bayes Information Criterion (BIC, Schwarz, 1978). 
C
C Symbols:
C
C X : 2 dimensional array storing the data;
C NO : full length of data;
C ITRANS : code for transformation;
C NEFF : number of eventual forecasting function;
C THD : user-supplied threshold values of X and Y;
C NTHD : number of thresholds.
C
C Remarks:
C
C Restrictions of the program:
C Number of data <= 1000;
C Number of data in any region not greater than 500;
C In particular, if NTHD=1, the number of data has to be not greater
C than 500;
C Maximum number of threshold values = 4;
C Maximum lag <= 20;
C Max number of predictions, EFF <= 1000.
C
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 MAIC, IPL, IPU, ITAIC, MAIC1, MAIC2, MAIC3, MAIC4
      DIMENSION IPOS(100),IPOS3(100),X(2,1000),THD(2,4),THDD(2,4)
      DIMENSION CMATX(2,5,32),ICMATX(2,5),THDXX(4),XMY(1000)
      DIMENSION NTHR(2),ID(2)
      DIMENSION NTHD(2),ID1(2),ID2(2),N0(2),N(2),NRCHK(2),NEFF(2)
      DIMENSION IDM(2),ITRANS(2),NLREG(2),CMA(5,150)
      DIMENSION BX(2),S(2),TAICM(2),XX(1000),YY(1000),ICM(150)
      DIMENSION CTHD(2,300),Y(1002),IX(1000),VALUE(150)
      DIMENSION CKY(1000),YYCKY(1002),MAIC(2),IAR(2,150)
      DIMENSION IARX(2,5),IARY(2,5),ILAGX(2,50,5),ILAGY(2,50,5)
      DIMENSION ILAG(2,50,150),ISTART(150,2),IES(2),MNO(150,2)
      DIMENSION MNRCAS(2,10,5),MCAS(2,10,5),NRCAS(160000,10)
      DIMENSION MAIC1(2),MAIC2(2,5),MAIC3(2,5),MAIC4(2,5)
      LOGICAL L,L2,L3
      CHARACTER*80 FILE2,FILE3,FILE4,FILE30
      NMAX=1000
      EOF=9.9**10
C.....Choose for one series (SETAR) or two series (TARSO/TARSC):
      WRITE(6,*)' ONE SERIES (= 1) OR TWO SERIES (= 2) : '
      READ(5,*) ANSWER
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Reading the candidate models:
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      WRITE(6,'(A)')'  Name of the file with candidate models:  '
      READ(5,'(A)') FILE30
C 
      IF (FILE30.EQ.' ') THEN
         FILE30='MODEL.DAT'
      END IF
      OPEN(12,FILE=FILE30,STATUS='OLD',READONLY)
C.....Model type (1 = open loop, 2 = closed loop):
      IF (ANSWER.EQ.2) THEN
         READ(12,*) MODEL
      ELSE
         MODEL=1
      ENDIF
      DO 5050 MKY=1,MODEL
C........Maximum number of thresholds to be searched:
         READ(12,*) NTHR(MKY)
C........Delays to be searched from 1 to ID2(MKY):
         READ(12,*) ID2(MKY)
         ID1(MKY)=1
C........Number of candidate models:
         READ(12,*) NRM
C........Read AR-orders and lags for candidate models:
         MAXAR=0
         DO 5026 MNRM=1,NRM
C........Model number:
         READ(12,*) MNO(MNRM,MKY)
C..............Number of AR parameters for each piece:
               READ(12,*)IAR(MKY,MNRM)
C..............Find the maximum number of AR-parameters:
               IF (IAR(MKY,MNRM).GT.MAXAR) THEN
                  MAXAR=IAR(MKY,MNRM)
               ENDIF
               I1=INT(REAL(IAR(MKY,MNRM)/5))
               I2=IAR(MKY,MNRM)-I1*5
               JS=1
               JE=5
               DO 5061 IL=1,I1
C.................Lag for each AR parameter:
                  READ(12,*)(ILAG(MKY,J,MNRM),J=JS,JE)
                  JS=JS+5
                  JE=JE+5
 5061          CONTINUE
               IF (I2.NE.0) THEN
                  J5=I1*5
                  READ(12,*)(ILAG(MKY,J5+JJ,MNRM),JJ=1,I2)
               ENDIF
               DO 5062 JL=1,IAR(MKY,MNRM)
C..............Adjust initial value starting position:
         ISTART(MNRM,MKY)=MAX0(ISTART(MNRM,MKY),ILAG(MKY,JL,MNRM))
 5062          CONTINUE
 5026    CONTINUE
 5050 CONTINUE
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C    Reading the input:
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C.....Read data from datafiles:
C
      DO 9400 JXY=1,2
      NMAX=1000
      EOF=9.9**10
C
      IF (JXY.EQ.1) THEN
         WRITE(6,'(A)')'  Give the name of the file containing'
         WRITE(6,'(A)')'  data on the output Y (TARSOY.DAT):  '
         READ(5,'(A)') FILE3
         IF (FILE3.EQ.' ') THEN
            FILE3='TARSOY.DAT'
         END IF
         OPEN(10,FILE=FILE3,STATUS='OLD',READONLY)
      ELSE
         IF(ANSWER.EQ.1) THEN
            FILE4=FILE3
c            OPEN(11,FILE=FILE4)
            OPEN(11,FILE=FILE4,STATUS='OLD',READONLY)
            GOTO 9500
         ELSE
         WRITE(6,'(A)')'  Give the name of the file containing'
         WRITE(6,'(A)')'  data on the input X (TARSOX.DAT):  '
         READ(5,'(A)') FILE4
         IF (FILE4.EQ.' ') THEN
            FILE4='TARSOX.DAT'
         END IF
         OPEN(11,FILE=FILE4,STATUS='OLD',READONLY)
      ENDIF
9500  CONTINUE
      ENDIF
C
      DO 121 I=1,NMAX
      X(JXY,I)=EOF
121   CONTINUE
      IF (JXY.EQ.1) THEN
         READ(10,*,END=131) (X(JXY,I),I=1,NMAX)
      ELSE
         READ(11,*,END=131) (X(JXY,I),I=1,NMAX)
      ENDIF
131   CONTINUE
      N0(JXY)=0
      DO 141 I=1,NMAX
      IF(X(JXY,I).EQ.EOF) GO TO 171
      N0(JXY)=N0(JXY)+1
141   CONTINUE
171   CONTINUE
         IF (JXY .EQ. 1) THEN
         WRITE(6,*)' Code for transforming the Y-data: '
         ELSE
             IF (ANSWER .EQ. 2) THEN
                 WRITE(6,*)' Code for transforming the X-data: '
             ELSE 
                 ITRANS(2)=ITRANS(1)
                 NRCHK(2)=NRCHK(1)
                 GOTO 7223
             ENDIF
         ENDIF
         WRITE(6,*)' No transformation     (1): '
         WRITE(6,*)' Square root           (2): '
         WRITE(6,*)' Log to base 10        (3): '
         WRITE(6,*)' Log to base E         (4): '
         WRITE(6,*)' Exp transformation    (5): '
         WRITE(6,*)' Square transformation (6): '
         WRITE(6,*)' 2*(SQRT(XT+1)-1)      (7): '
         WRITE(6,*)' First difference      (8): '
         WRITE(6,*)' Difference of LOG    (9): '
         WRITE(6,*)' 1000*(LOG10*X-7)     (10): '
         WRITE(6,*)' 1000*(LOG10*X)       (11): '
         WRITE(6,*)' Type your choice: '
         read(5,*) ITRANS(JXY)
         WRITE(6,*)' No. of data chopped off ( 0 ?): '
         read(5,*) NRCHK(JXY)
 7223    CONTINUE
         N(JXY)=N0(JXY)-NRCHK(JXY)
         IF (ITRANS(JXY) .NE. 8) GOTO 7222
         NJXY=N(JXY)
         DO 7224 KY=1,N0C
 7224    XMY(KY)=X(JXY,KY)
         CALL DIFF1(NJXY,N0C,XMY)
         N(JXY)=NJXY
         N0(JXY)=N0C
         DO 7225 KY=1,N0C
 7225    X(JXY,KY)=XMY(KY)
 7222    CONTINUE
 9400 CONTINUE
         IF (N0(1).NE.N0(2)) THEN
            WRITE(6,*)' X and Y series must be of equal length!'
            WRITE(6,*)' Program stopped.'
            GOTO 111
         ENDIF
      WRITE(6,'(A)')'  Give the name of the output file (tarso.out):  '
      read(5,'(A)') FILE2
      IF (FILE2.EQ.' ') THEN
         FILE2='TARSO.OUT'
      END IF
      OPEN(9,FILE=FILE2,STATUS='NEW')
      WRITE(9,7197)
 7197 FORMAT(' RESULTS OF TARSO-MODEL SELECTION.')
      WRITE(9,7198)
 7198 FORMAT(/' Program MKT13, M. Knotters and 
     1J.G. de Gooijer, 1997.')
      DO 7550 MKY=1,MODEL
         WRITE(9,7501) NTHR(MKY)
 7501    FORMAT(///' Maximum number of thresholds to be searched: ',I2)
         WRITE(9,7502) ID2(MKY)
         ID1(MKY)=1
 7502    FORMAT(/' Search delays from 1 to : ',I3)
         WRITE(9,7504) NRM
 7504    FORMAT(' Number of candidate models : ',I3)
         DO 7526 MNRM=1,NRM
         WRITE(9,7503) MKY,MNO(MNRM,MKY)
 7503    FORMAT(/' Model key = ',I3,' , Model no. ',I3)
               WRITE(9,7505)IAR(MKY,MNRM)
 7505          FORMAT(' AR-order = ',I3)
                  WRITE(9,7506)(ILAG(MKY,IL,MNRM),
     1                          IL=1,IAR(MKY,MNRM))
 7506             FORMAT(' Lags : ',10I3)
 7526    CONTINUE
 7550 CONTINUE
      WRITE(6,*)' Selection with user-supplied thresholds? '
      WRITE(6,*)' 1 = yes, 0 = no: '
      READ(5,*)IUS
      IF (IUS.EQ.1) GOTO 7508
      WRITE(6,*)' Give the interpercentile range in which the '
      WRITE(6,*)' thresholds are searched.'
      WRITE(6,*)' Give the lower percentile:'
      READ(5,*)IPL
      WRITE(6,*)' Give the upper percentile:'
      READ(5,*)IPU
      WRITE(9,7507)IPL,IPU
 7507 FORMAT(/' Thresholds are searched from the ',F10.4,
     1'th percentile to the ',F10.4,'th percentile. ')
      WRITE(6,*)' Give the steplength for candidate thresholds:'
      READ(5,*)STEP
      WRITE(9,7509)STEP
 7509 FORMAT(/' Steplength in searching thresholds is ',F10.4)
 7508 CONTINUE
      WRITE(9,7199) (X(1,I),I=1,N0(1))
 7199 FORMAT(//' Y data (full length without transformation ) : '/
     1(' ',7F10.3))
      IF (ANSWER.EQ.1) GOTO 7201
      WRITE(9,7200) (X(2,I),I=1,N0(1))
 7200 FORMAT(/' X data (full length without transformation ) : '/
     1(' ',7F10.3))
 7201 CONTINUE
      WRITE(9,7202)ITRANS(1),ITRANS(2)
 7202 FORMAT(/' Transformation of Y = ',I2,
     1', transformation of X = ',I2)
      WRITE(9,*)' No transformation     (1)'
      WRITE(9,*)' Square root           (2)'
      WRITE(9,*)' Log to base 10        (3)'
      WRITE(9,*)' Log to base E         (4)'
      WRITE(9,*)' Exp transformation    (5)'
      WRITE(9,*)' Square transformation (6)'
      WRITE(9,*)' 2*(SQRT(XT+1)-1)      (7)'
      WRITE(9,*)' First difference      (8)'
      WRITE(9,*)' Difference of LOG    (9)'
      WRITE(9,*)' 1000*(LOG10*X-7)     (10)'
      WRITE(9,*)' 1000*(LOG10*X)       (11)'
      WRITE(9,7203)NRCHK(1),NRCHK(2)
 7203 FORMAT(//' Number of Y-data chopped off: ',I3,/
     1' Number of X-data chopped off: ',I3,//)
C
C
C
 7301 WRITE(6,*)' Selection by AIC (1), corrected AIC (2) or BIC (3)?'
      READ(5,*)ISEL
      IF (ISEL .LT. 1 .OR. ISEL .GT. 3) THEN
         WRITE(6,*)'Choose 1, 2 or 3!!!'
         GOTO 7301
      ENDIF
      IF (ISEL.EQ.1) THEN
         WRITE(9,*)' Selection by AIC. '
      ELSE
         IF (ISEL.EQ.2) THEN
            WRITE(9,*)' Selection by AIC (corrected). '
         ELSE
            WRITE(9,*)' Selection by BIC. '
         ENDIF
      ENDIF
C.....MKY = model key word
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Transform data:
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      CALL TRANS(X,X,N0,ITRANS,N)
C
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C     Rough identification
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      N1=N(1)
      DO 340 I=1,N1
  340 CKY(I)=X(1,I)
      CALL DESACF(N1,CKY,1.0,BX(1),S(1),0)
      AMAX=BX(1)+5.*S(1)
      AMIN=BX(1)-5.*S(1)
      N2=N(2)
      DO 350 I=1,N2
  350 CKY(I)=X(2,I)
      CALL DESACF(N2,CKY,1.0,BX(2),S(2),0)
      IF (IUS.EQ.1) THEN
         DO 351 MKY=1,MODEL
            NTX=NTHR(MKY)
               DO 352 II=1,NTX
                  WRITE(6,*)' Model key 1,',II,'th threshold value:'
                  READ(5,*)CTHD(MKY,II)
  352          CONTINUE
  351       CONTINUE
      ELSE
C********Modification by M. Knotters. Candidate thresholds at intervals
C        of 1 in between 10th and 90th percentile of the empirical
C        distribution of the output variable. Subroutine PCAND.
         CALL PCAND(X,N1,CTHD,IPL,IPU,STEP)
      ENDIF
      WRITE(9,1672)
 1672 FORMAT(' Model key Model no.  Criterion Delay Threshold values ')
      JMM=0
C*****************************************************************
C Assign AR orders to X and Y terms in a regime:
C*****************************************************************
      IF (ANSWER .EQ. 1) THEN
         ITC=NRM
      ELSE
         ITC=NRM**2
      ENDIF
      IF (ITC.GT.160000) THEN
         WRITE(6,*)' Too much candidate models! '
         GOTO 111
      ENDIF
      IF (ANSWER .EQ. 1) THEN
         CALL COMBIX(NRCAS,MKY,NRM)
      ELSE
         CALL COMBI(NRCAS,MKY,NRM)
      ENDIF
C***********************************************************************
C Loop from model key 1 (open loop) to model key 2 (closed loop)
C***********************************************************************
      DO 2002 MKY=1,MODEL
C***********************************************************************
C Loop from delay ID1(MKY) to ID2(MKY)
C***********************************************************************
      II1=ID1(MKY)
      II2=ID2(MKY)
      DO 2003 II3=II1,II2
      ID(MKY)=II3
      WRITE(9,*)'Delay = ',ID(MKY)
C.....Initialize the AIC of the selected model. MAIC1 is the minimum AIC
C.....(AICc, BIC) given a delay and a maximum number of thresholds.
      MAIC1(MKY)=1.0E+37
      NTHH=NTHR(MKY)
      IF (IUS .EQ. 0) THEN
C         IH = NTHH
         IH = 0
      ELSE
         IH = NTHH
      ENDIF
C*****************************************************************
C Loop from 0 to NTHD thresholds if IUS = 0. Loop from NTHD to
C NTHD if IUS = 1:
C*****************************************************************
      DO 4501 NTHE=IH,NTHH
      NTT=NTHE+1
C.....MAIC2 is the minimum AIC (AICc, BIC) given a delay and a fixed
C.....number of thresholds.
      MAIC2(MKY,NTT)=1.0E+37
      NTHD(MKY)=NTHE
      LOOP=100000
C.....L2 is set .TRUE. means that RAIC returns AIC only.
      L2=.TRUE.
      L3=.TRUE.
C*****************************************************************
C Loop from 1 to LOOP: combinations of threshold values.
C*****************************************************************
      DO 2 I=1,LOOP
C.....Assign threshold values.
         NTHDX=NTHD(1)
         CALL COMLEX(IPOS,NTHDX,200,L2,*6,*1)
    6    CONTINUE
         DO 3 IL=1,NTHDX
            LL=IPOS(IL)
    3    THD(1,IL)=CTHD(1,LL)
         IF (MODEL .EQ. 1) THEN
            NTHDX=NTHD(1)
         ELSE
            NTHDX=NTHD(2)
         ENDIF
         CALL COMLEX(IPOS3,NTHDX,200,L3,*7,*1)
    7    CONTINUE
         DO 8 IL=1,NTHDX
            LL=IPOS3(IL)
    8    THD(2,IL)=CTHD(2,LL)
C.....Choose appropriate starting position.
         IES(MKY)=ID2(MKY)
         DO 3400 J=1,NRM
            IES(MKY)=MAX0(IES(MKY),ISTART(J,MKY))
 3400    CONTINUE
         IES(MKY)=IES(MKY)+1
C.....Initialize ITAIC. ITAIC is a dummy which sums the minimum
C.....AIC (AICc, BIC) for each regime for a given delay and given 
C.....threshold values.
         ITAIC=0
         NREG=NTHD(MKY)+1
C*****************************************************************
C Loop from 1 to number of regimes.
C*****************************************************************
         DO 4508 IT=1,NREG
C.....MAIC3 is the minimum AIC (AICc, BIC) within a regime, given a 
C.....delay and threshold values.
            MAIC3(MKY,IT)=1.0E+37
            DO 4509 IJJ=1,NREG
               IARX(MKY,IJJ)=0
               IARY(MKY,IJJ)=0
 4509       CONTINUE
            DO 4507 ICOMB=1,ITC
               IP1=1
               IP2=2
               IF (IAR(MKY,(NRCAS(ICOMB,IP1))).EQ.0) THEN
                  IARX(MKY,IT)=0
               ELSE
                  IARX(MKY,IT)=IAR(MKY,NRCAS(ICOMB,IP1))
                  DO 4505 I4=1,IARX(MKY,IT)
                     ILAGX(MKY,I4,IT)=ILAG(MKY,I4,NRCAS(ICOMB,IP1))
 4505             CONTINUE
               ENDIF
               IF (ANSWER .EQ. 1) GOTO 4546
               IF (IAR(MKY,(NRCAS(ICOMB,IP2))).EQ.0) THEN
                  IARY(MKY,IT)=0
               ELSE
                  IARY(MKY,IT)=IAR(MKY,NRCAS(ICOMB,IP2))
                  DO 4506 I5=1,IARY(MKY,IT)
                     ILAGY(MKY,I5,IT)=ILAG(MKY,I5,NRCAS(ICOMB,IP2))
 4506             CONTINUE
               ENDIF
 4546          CONTINUE
            CALL RIDENT(X,N,NTHD,THD,ID,MAIC,CMATX,ICMATX,MODEL,ISEL,
     1      IARX,IARY,ILAGX,ILAGY,IEM,IES,IT,MAXAR)
C.....Seek the minimum MAIC3:
               IF (MAIC3(MKY,IT) .LT. MAIC(MKY)) GOTO 4507
               MAIC3(MKY,IT)=MAIC(MKY)
               DO 4703 LM=1,2
                  MNRCAS(MKY,LM,IT)=NRCAS(ICOMB,LM)
 4703          CONTINUE
 4507       CONTINUE
            ITAIC=ITAIC+MAIC3(MKY,IT)
 4508    CONTINUE
C*****************************************************************
C End of loop from 1 to number of regimes.
C*****************************************************************
C.....Calculate the effective sample size:
      IEFF=N0(MKY)-IES(MKY)+1
      IF (ISEL .EQ. 1) THEN
C.....Akaike Information Criterion
         ITAIC=ITAIC+2*NTHE
      ELSE IF (ISEL .EQ. 2) THEN
C.....Corrected Akaike Information Criterion
         ITAIC=ITAIC+IEFF*(IEFF+NTHE)/(IEFF-NTHE-2)
      ELSE
C.....Bayes Information Criterion
C         ITAIC=ITAIC+LOG(REAL(IEFF))*NTHE (false definition!)
C         When using BIC the number of thresholds must be known on the 
C         basis of prior information!
          ITAIC=ITAIC
      ENDIF
C.....Seek the minimum MAIC2:
c      WRITE(9,*)' ITAIC = ',ITAIC
c      DO 4708 LMM=1,NTHE
c         WRITE(9,*)' THD ',LMM,' = ', THD(MKY,LMM)
c 4708 CONTINUE
      IF (MAIC2(MKY,NTT) .LT. ITAIC) GOTO 2
      MAIC2(MKY,NTT)=ITAIC
      DO 4704 LMM=1,NTHE
         THDD(MKY,LMM)=THD(MKY,LMM)
 4704 CONTINUE               
      DO 4705 LNN=1,NREG
C.....MAIC4 is the minimum AIC (AICc, BIC) in a regime given the 
C.....delay and the number of thresholds.
         MAIC4(MKY,LNN)=MAIC3(MKY,LNN)
         DO 4706 LN=1,2
            MCAS(MKY,LN,LNN)=MNRCAS(MKY,LN,LNN)
 4706    CONTINUE
 4705 CONTINUE
    2 CONTINUE
C*****************************************************************
C End of loop from 1 to LOOP: combinations of threshold values.
C*****************************************************************
    1 CONTINUE
      DO 4602 JII=1,NREG
         DO 4601 JI=1,2
            WRITE(9,*)' Case in term ',JI,' of regime ',JII,' = '
            WRITE(9,*)MCAS(MKY,JI,JII)
 4601    CONTINUE
         WRITE(9,*)' AIC/AICc/BIC of regime =',MAIC4(MKY,JII)
 4602 CONTINUE
      WRITE(9,*)' Minimum AIC/AICc/BIC for ',NTHE,' thresholds = '
      WRITE(9,*)MAIC2(MKY,NTT)
      DO 4707 ML=1,NTHE
         WRITE(9,*)' The ',ML,'th threshold value = ',THDD(MKY,ML)
 4707 CONTINUE
C.....Seek the minimum MAIC1:
      IF (MAIC1(MKY).LT.MAIC2(MKY,NTT)) GOTO 4501
      MAIC1(MKY)=MAIC2(MKY,NTT)
 4501 CONTINUE
C******************************************************************
C End of loop from 0 to NTHD thresholds.
C******************************************************************
      WRITE(9,*)' Minimum AIC/AICc/BIC = ',MAIC1(MKY)
      WRITE(9,*)' Effective sample size = ',IEFF
      MAIC1(MKY) = MAIC1(MKY)/IEFF
      WRITE(9,*)' Normalized AIC/AICc/BIC =', MAIC1(MKY)
      WRITE(9,*)' Selected model: '
      WRITE(9,*)' Model key = ', MKY
 2003 CONTINUE 
 2002 CONTINUE
  111 CONTINUE
      STOP
      END
      SUBROUTINE COMLEX(K,IR,N,L,*,*)
C==================================================================
C==================================================================
C Purpose: combinations of IR objects taken from 1,2,...N.
C Input: IR
C        N
C        L = logical variable: should be set .TRUE. if K is
C            to contain (1,2,...IR) when COMLEX is first called.
C Output: K = containing IR object from N numbers.
C Remarks: the first exit means that other N C IR combinated are
C          not enumerated;
C          the last EXIT takes place if all combinations have been
C          enumerated.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION K(1)
      LOGICAL L
      IND=0.
      IF(.NOT.L) GOTO 1
      DO 2 I=1,IR
    2 K(I)=I
      L=.FALSE.
      RETURN 1
    1 CONTINUE
      DO 3 I=1,IR
      II=IR+1-I
      IF(K(II) .GE. N-IR+II) GOTO 3
      K(II)=K(II)+1
      IS=II+1
      IF(IS .GT. IR) RETURN1
      DO 4 J=IS,IR
    4 K(J)=K(J-1)+1
      RETURN 1
    3 CONTINUE
      RETURN 2
      END
      SUBROUTINE CAND(BX,S,CTHD)
C===================================================================
C===================================================================
C Purpose : provide 100 choices of cutting points as threshold
C           values. (100 pts equally divided +-2 std dev. around the mean.
C Input : BX = sample mean of data;
C         S = its sample sd deviation.
C Output : CTHD contains the candidates for the threshold values.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION CTHD(2,300),CHOICE(100),CHO(100),BX(1),S(1)
C.....MCKY = candidate models key (tarso or tarsc)
      DO 4 MCKY=1,2
      IF (MCKY .EQ. 1) MCKYM=1
      IF (MCKY .EQ. 2) MCKYM=2
C     MARTIN KNOTTERS, 25-11-1996: MCKYM 1 EN 2 VERWISSELD I.V.M.
C     THRESHOLDS IN DE X-VARIABELE I.P.V. DE Y-VARIABELE
      DO 1 I=1,100
   1  CTHD(MCKYM,I)=BX(MCKY)-(1.-(2.*I-1)/100.)*2.*S(MCKY)
C.....Search around the std dev.
C1    CTHD(MCKYM,I)-BX(MCKY)-(1.-(2.*I-1)/60.)*S(MCKY)
   4  CONTINUE
      RETURN
      END
      SUBROUTINE DIFF1(N,N0,X)
C===================================================================
C===================================================================
C     First difference of data.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(1000)
      N0=N0-1
      N=N-1
      DO 1 I=1,N0
    1 X(I)=X(I+1)-X(I)
      WRITE(9,10) (X(I),I=1,N0)
   10 FORMAT(/' DATA (FIRST DIFFERENCED) '/
     1 (/' ',7F12.2))
      RETURN
      END
      SUBROUTINE RIDENT(X,N,NTHD,CTHD,ID,MAIC,CMATX,ICMATX,
     1MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,IEM,IES,IT,MAXAR)
C===================================================================
C===================================================================
C Purpose: pinpoint the rough threshold values and the delay.
C Input: X = data;
C        N = its number;
C        NTHD+1 = number of regions;
C        ID  constitute the delay.
C Output: ** K = 1 means: regress X on past X and Y **;
C         ** K = 2 means: regress Y on past Y and X **;
C         MAIC(K) = minimum AIC among the possible TARSO/TARSC models;
C         CMATX(K,I,J) = J th coefficient of the I th AR model;
C         ICMATX(K,I) = number of parameters of the I th AR model;
C         IDM(K) = 'best' delays corresponding to MAICE.
C Remark: CTHD is working space for storing possible sets of thres-
C         hold values.
C SUBROUTINES CALLED : COMLEX,RAIC
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 MAIC
      LOGICAL L1/.TRUE./,L2,L3
      DIMENSION N(2),NTHD(2),TAICM(2)
      DIMENSION X(2,1000),THD(2,4),MAIC(2),ID(2)
      DIMENSION ICMATX(2,5),CMATX(2,5,32),CTHD(2,300)
      DIMENSION IARX(2,5),IARY(2,5)
      DIMENSION ILAGX(2,50,5),ILAGY(2,50,5),IES(2)
      DIMENSION NE(2),RES(2,1000),RDN(2,1000)
C.....Set an astronomically large number to MAIC
C.....in order to find the minimum for MAIC.
C      MAIC(1)=1.0E+37
C      MAIC(2)=1.0E+37
C.....L2 is set .TRUE. means that RAIC returns TAICM only.
      L2=.TRUE.
C.....MCKY = key of model choice
      DO 300 MCKY=1,MODEL
C         IF (MCKY .EQ. 2) GOTO 300
         NT=NTHD(MCKY)
         DO 301 IL=1,NT
            THD(MCKY,IL)=CTHD(MCKY,IL)
  301    CONTINUE
      CALL RAIC(X,N,THD,NTHD,ID,CMATX,ICMATX,TAICM,L1,
     *MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,NE,IES,IT,MAXAR)
         MAIC(MCKY)=TAICM(MCKY)
c      PRINT*,' AIC in RIDENT = ',MAIC(MCKY)
  300 CONTINUE
      RETURN
      END
      SUBROUTINE SORT(X,N,AX,IAX1,IAX2,THD,NTHD,ID,NOBS,IER,IST,
     *YY,IIARX,IIARY,IILAGX,IILAGY,MAXAR)
C===================================================================
C===================================================================
C Purpose: sort the data for which an appropriate AR-model applies.
C Input: X = data;
C        N = its dimension;
C        AX = array containing the sorted data;
C        THD    = containing the threshold value;
C        NTHD+1 = number of regions;
C        ID     = delay parameter.
C Output: error code = 0 : O.K.
C                      1 : some regions do not have enough data to
C                          estimate the corresponding AR-model.
C         IST = the starting position for the sorting;
C         NOBS(I) = the number of data falling in the Ith region.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION NOBS(5),YY(1000),THD(4),X(1000)
      DIMENSION IIARX(5),IIARY(5),IILAGX(50,5),IILAGY(50,5)
      DIMENSION AX(IAX1,IAX2,5)
      JEND=NTHD+1
C.....Clear NOBS.
      DO 1 I=1,JEND
    1 NOBS(I)=0
C.....Sort X's into AX's.
      DO 3 I=IST,N
         ICP=1
C.....Assign to first region for NTHD = 0.
         IF(NTHD .EQ. 0) GOTO 5
C.....First assign to last region.
         ICP=NTHD+1
         II=I-ID
C.....See to which region X(I) belongs. Note that it is determined by
C.....X(I-DELAY).
         DO 4 K=1,NTHD
            IF(X(II) .GT. THD(K)) GOTO 4
            ICP=K
C.....Ah, it is found.
            GOTO 5
    4    CONTINUE
    5    CONTINUE
C.....Indicate the current position X(I) occupies in the ICP region.
         NOBS(ICP)=NOBS(ICP)+1
         NOB=NOBS(ICP)
C.....Assign the first column of AX(NOB,I,ICP).
         AX(NOB,1,ICP)=1.0
C.....Assign the X-part of AX(NOB,I,ICP).
         KENDX=IIARX(ICP)+1
         DO 6 K=2,KENDX
            K3=K-1
            K22=IILAGX(K3,ICP)
            AX(NOB,K,ICP)=X(I-K22)
    6    CONTINUE
C.....Assign the Y-part of AX(NOB,I,ICP).
         KSTART=KENDX+1
         KENDY=KENDX+IIARY(ICP)
         DO 61 K=KSTART,KENDY
            K3=K-KENDX
            K22=IILAGY(K3,ICP)
            AX(NOB,K,ICP)=YY(I-K22)
   61    CONTINUE
C.....Assign the last column of AX(NOB,I,ICP).
         KEND=KENDY+1
         AX(NOB,KEND,ICP)=X(I)
    3 CONTINUE
C.....Check if enough data to estimate the AR-model in each of the regions.
C.....Check if the regime contains enough data to apply Akaike's 
C     Information Criterion.
C******Modification by M. Knotters, 24-4-1997. See Sakamoto et al., 1986, 
C      p. 83. Akaike Information Criterion Statistics. Reidel, Dordrecht.
C******This modification is not active.
      IER=0
      DO 7 J=1,JEND
         NN=NOBS(J)
c         RNN1=2*SQRT(REAL(NN))
c         RNN2=(REAL(NN))/2
c         IHX = IIARX(J)
c         IHY = IIARY(J)
C         The minimum number of observations in a regime can be based on
C         the number of free parameters of the actual candidate model 
C         (AR-parameters + constant + residual variance) or at the number
C         of free parameters of the largest candidate model:
C         KK=IHX+IHY+2
c          KK=2*MAXAR+2
c         RKK=REAL(KK)
C        The minimum number of observations in a regime can be fixed at 
C        for instance 20. This constraint is active.
c         IF(NN .LT. 20) GOTO 74
         IF(NN .GE. 20) GOTO 7
c         IF(RNN1 .GT. RKK .AND. RNN2 .GT. RKK) GOTO 7
   74    IER=1
C.....The Jth regime lacks data, so return with IER=1.
         RETURN
    7 CONTINUE
C.....Check if variables in a regime have variance greater than zero,
C     in order to perform least squares estimation via Housholder
C     transformation successfully.
C     Modification by M. Knotters, 17 April 1997.
      IER=0
      DO 72 J=1,JEND
         NN=NOBS(J)
         KEND=IIARX(J)+IIARY(J)+2
         DO 73 JJJ=2,KEND
            RMIN=AX(1,JJJ,J)
            RMAX=AX(1,JJJ,J)
            DO 71 JJ=1,NN
               IF (AX(JJ,JJJ,J).LT.RMIN) RMIN=AX(JJ,JJJ,J)
               IF (AX(JJ,JJJ,J).GT.RMAX) RMAX=AX(JJ,JJJ,J)
   71       CONTINUE
            IF (RMIN .NE. RMAX) GOTO 73
C.....A variable in the Jth regime has zero variance. Therefore,
      the program returns with IER=1.
            IER=1
            RETURN
   73    CONTINUE
   72 CONTINUE
      RETURN
      END
      SUBROUTINE HUSHLD(AH1,N,K,IA11)
C===================================================================
C===================================================================
C Purpose: HOUSHOLDER TRANSFORMATION
C Input : AH1 = array to be transformed;
C         N = number of columns;
C         K = number of rows;
C         IA11 = number of columns of AH1 in the calling program.
C Output: AH1 = transformed array.
C==================================================================
C==================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION AH1(IA11,1),Z(1000)
      TOL=1.0E-30
      NK=MIN0(N,K)
      DO 100 II=1,NK
      H=0.0
      DO 10 I=II,N
      Z(I) = AH1(I,II)
   10 H=H+Z(I)*Z(I)
      IF(H .GT. TOL) GOTO 40
      G=0.0
      GOTO 100
   40 G=SQRT(H)
      F=AH1(II,II)
      IF(F .GE. 0.0) G=-G
      Z(II)=F-G
      H=H-F*G
      IF(II .EQ. K) GOTO 100
      II1=II+1
      DO 90 J=II1,NK
      S=0.0
      DO 20 I=II,N
   20 S=S+Z(I)*AH1(I,J)
      S=S/H
      DO 30 I=II,N
   30 AH1(I,J)=AH1(I,J)-Z(I)*S
   90 CONTINUE
  100 AH1(II,II)=G
      RETURN
      END
      SUBROUTINE ARMFIT(AH1,IA11,AC1,K,N,VA,IMIN,AICM,ISEL)
C==================================================================
C==================================================================
C Purpose: given the lags for different regions, compute the AIC
C          for the AR-model in the Ith region.
C Input: AH1 = housholder transformed array (so it is upper triangular);
C        IA11 = number of rows of AH1 in the calling program;
C        K = number of columns;
C        N = number of rows (number of data);
C        ISEL = indicator for information criterion.
C Output: AR(IMIN-1) = the chosen AR-model;
C         IMIN = the number parameters of the AR-model;
C         AICM = its corresponding information criterion;
C         VA = mean sum of squared errors;
C         AC1 = contains the coefficients of the AR-model.
C Here, AC2 and AC3 are working vectors.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION AH1(IA11,1)
      DIMENSION AC1(50),AC2(50),AC3(50)
C.....DIMENSION AC1(NK),AC2(NK),AC3(NK)
      K1=K+1
      K1=MIN0(N,K1)
      OSD=0.0E00
      FN=N
      IF (ISEL .NE. 1) GOTO 11
C.....Aikaike Information Criterion
      DO 10 I=1,K1
         M=K1-I+1
         MP=M-2
C        MP is the number of autoregressive terms
         OSD=OSD+AH1(M,K1)*AH1(M,K1)
         AC2(M)=OSD/FN
   10 AC3(M)=FN*LOG(AC2(M))+2*(MP+1)
C   10 AC3(M)=FN*LOG(AC2(M))+2*(MP)
      GOTO 15
   11 IF (ISEL .NE. 2) GOTO 13
C.....Corrected Akaike Information Criterion
      DO 12 I=1,K1
         M=K1-I+1
         MP=M-2
         OSD=OSD+AH1(M,K1)*AH1(M,K1)
         AC2(M)=OSD/FN
         MH=MP+3
         IF (FN .EQ. MH) THEN
            AC3(M)=1.0E+37
         ELSE
      AC3(M)=FN*LOG(AC2(M))+(FN*(FN+MP+1))/(FN-MP-3)
C      AC3(M)=FN*LOG(AC2(M))+(FN*(FN+MP))/(FN-MP-2)
         ENDIF
   12 CONTINUE
      GOTO 15
C.....Bayes Information Criterion
   13 DO 14 I=1,K1
         M=K1-I+1
         MP=M-2
         OSD=OSD+AH1(M,K1)*AH1(M,K1)
         AC2(M)=OSD/FN
   14 AC3(M)=FN*LOG(AC2(M))+(MP+1)*LOG(FN)
C   14 AC3(M)=FN*LOG(AC2(M))+(MP)*LOG(FN)
   15 CONTINUE  
      IMIN=K1-1
      AICM=AC3(K1)
      IF(IMIN .EQ. 1) GOTO 200
      DO 100 M=IMIN,IMIN
         AC1(M)=AH1(M,K1)/AH1(M,M)
         MM1=M-1
         DO 110 II=1,MM1
            I=M-II
            SUM=DBLE(AH1(I,K1))
            I1=I+1
            DO 120 J=I1,M
  120       SUM=SUM-DBLE(AC1(J))*DBLE(AH1(I,J))
  110    AC1(I)=SUM/AH1(I,I)
  100 CONTINUE
      VA=AC2(IMIN+1)
      RETURN
  200 VA=AC2(2)
      AC1(1)=AH1(1,K1)/AH1(1,1)
      RETURN
      END
      SUBROUTINE RAIC(X,N,THD,NTHD,ID,CMATX,ICMATX,
     *TAICM,L,MODEL,ISEL,IARX,IARY,ILAGX,ILAGY,
     *NOBST,IES,IT,MAXAR)
C===================================================================
C===================================================================
C Purpose: after sorting and Housholder transformation, the
C          AIC of the particular TARSO/TARSC model is returned.
C RAIC has also the ability of printing the relevant information of
C the TARSO/TARSC model and provides diagnostics on the fitted residuals
C if L is set .FALSE. .
C Input : X = data;
C         N =its length;
C         THD = array of threshold values;
C         NTHD+1 = the number of regions;
C         ID = delay;
C         L : Boolean variable: if .TRUE. only AIC is returned;
C                               if .FALSE. see above;
C         ISEL = indicator for information criterion: Akaike Information
C                Criterion (1), a corrected AIC (2) or Bayes Information
C                Criterion (3);
C Output : CMATX(K,I,J) = Jth coefficient for Ith AR model;
C          ICMATX = number of parameters for the Ith AR model;
C          ** K = 1 means: regress X on X and Y **
C          ** K = 2 means: regress Y on Y and X **
C          TAICM = information criterion for the TARSO/TARSC model.
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION THD(2,4),N(2),NTHD(2),ID(2)
      DIMENSION CMATX(2,5,32),ICMATX(2,5),X(2,1000),YY(1000)
     *,THDXX(4)
      DIMENSION AX(500,50,5),SAX(500,50),AC1(50),NOBS(5),ICM(5)
      DIMENSION TAICM(2),XX(1000),NOBST(2),CMA(5,50)
      DIMENSION IARX(2,5),IARY(2,5)
      DIMENSION ILAGX(2,50,5),ILAGY(2,50,5),IES(2)
      DIMENSION IIARX(5),IIARY(5),IILAGX(50,5),IILAGY(50,5)
      DIMENSION RES(2,1000),RDN(2,1000),SIMV(1000),DENORM(1000)
C
      INTEGER LL1,UU,K2,K1,J1,IA(50,5),MFIT,ANSWER1,NOBSTT,ANSWER2
      INTEGER ANSWER3,K3,KK
      REAL*8 IC(30)
C
      LOGICAL L
      DATA IAX1,IAX2,IAX3/500,50,2/
C.....Sort the data for estimating the TARSO/TARSC model.
      J1=1
      J2=2
      DO 333 L1=1,MODEL
         IST=IES(L1)
         IDXX=ID(L1)
         NXX=N(L1)
         NTHDXX=NTHD(L1)
         DO 332 L2=1,5
            IIARX(L2)=IARX(L1,L2)
            IIARY(L2)=IARY(L1,L2)
            DO 327 ITEL=1,IIARX(L2)
               IILAGX(ITEL,L2)=ILAGX(L1,ITEL,L2)
  327       CONTINUE
            DO 328 ITEL=1,IIARY(L2)
               IILAGY(ITEL,L2)=ILAGY(L1,ITEL,L2)
  328       CONTINUE
  332    CONTINUE
         DO 331 L2=1,4
  331    THDXX(L2)=THD(L1,L2)
         NJ2=N(J2)
         NJ1=N(J1)
         DO 330 L2=1,NJ1
  330    XX(L2)=X(J1,L2)
         DO 329 L2=1,NJ2
  329    YY(L2)=X(J2,L2)
      CALL SORT(XX,NXX,AX,IAX1,IAX2,THDXX,NTHDXX,IDXX,NOBS,IER,
     *IST,YY,IIARX,IIARY,IILAGX,IILAGY,MAXAR)
C.....If (IER.EQ.1) then some region lacks data with which to estimate
C.....the model, so TAICM is set very large and control is given back
C.....to the calling program.
         IF(IER.NE.1) GOTO 1
         TAICM(L1)=1.0E+37
         IF(.NOT.L) WRITE(9,15)
   15    FORMAT('1 SOME REGIONS LACK DATA FOR ESTIMATION ')
         GO TO 1691
C.....TAICM, finally, is the AIC for the particular model.
C.....Initially, it is set to 0.0 .
    1    TAICM(L1)=0.0
C.....NOBST = total number of data for estimating the TARSO/TARSC model.
         NOBST(L1)=0.0
         KK=IARX(L1,IT)+IARY(L1,IT)
            K1=KK+2
            K2=KK+1
            NOB=NOBS(IT)
            NOBST(L1)=NOBST(L1)+NOB
C.....SAX contains the augmented 'design' matrix of the Ith region.
C.....K1 is the number of columns in SAX, NOB is the number of rows.
            DO 3 I1=1,NOB
            DO 3 I2=1,K1
            SAX(I1,I2)=AX(I1,I2,IT)
    3 continue
      CALL HUSHLD(SAX,NOB,K1,IAX1)
      CALL ARMFIT(SAX,IAX1,AC1,K2,NOB,VA,IMIN,AICM,ISEL)
            TAICM(L1)=AICM
c      PRINT*,' AIC in raic = ',TAICM(L1)
 1691    J1=2
         J2=1
  333 CONTINUE
      RETURN
      END
      SUBROUTINE TRANS(X,Y,N0,ITRANS,N)
C===================================================================
C===================================================================
C Purpose: to transform data.
C Input: X = array of data;
C        N = length of data;
C        ITRANS : 1 = no transformation;
C                 2 = square root;
C                 3 = log to the base 10;
C                 4 = log to the base e;
C                 5 = EXP(X);
C                 6 = SQUARE;
C                 7 = 2*(SQRT(XT+1)-1.);
C                 8 = first difference;
C                 9 = difference of LOG;
C                10 = 1000*(LOG10*X-7)
C                11 = 1000*(LOG10*X)
C Output: Y = transformed X
C===================================================================
C===================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(2,1),Y(2,1),N(1),ITRANS(1),N0(1),YY(1000)
      DO 80 K=1,2
      ITC=ITRANS(K)
      NC=N0(K)
      GOTO (1,2,3,4,5,6,7,8,9,10,11,12,13) ,ITC
    1 GO TO 80
    2 DO 21 I=1,NC
   21 Y(K,I)=SQRT(X(K,I))
      GO TO 80
    3 DO 31 I=1,NC
   31 Y(K,I)=LOG10(X(K,I))
      GO TO 80
    4 DO 41 I=1,NC
   41 Y(K,I)=LOG(X(K,I))
      GO TO 80
    5 DO 51 I=1,NC
   51 Y(K,I)=EXP(X(K,I))
      GO TO 80
    6 DO 61 I=1,NC
      T=X(K,I)
   61 Y(K,I)=T*T
      GO TO 80
    7 DO 71 I=1,NC
   71 Y(K,I)=2.*(SQRT(X(K,I)+1.)-1.)
    8 GO TO 80
    9 DO 91 I=1,NC
   91 Y(K,I)=LOG(X(K,I))
      DO 92 I=1,NC
   92 YY(I)=Y(K,I)
      NKK=N(K)
      N0KK=N0(K)
      CALL DIFF1(NKK,N0KK,YY)
      N(K)=NKK
      N0(K)=N0KK
      DO 93 I=1,N0KK
   93 Y(K,I)=YY(I)
      GO TO 80
   10 DO 103 I=1,NC
  103 Y(K,I)=1000.*(LOG10(X(K,I))-7.)
      GO TO 80
   11 DO 113 I=1,NC
  113 Y(K,I)=1000.*LOG10(X(K,I))
      GO TO 80
   12 DO 882 I=1,NC
  882 Y(K,I)=Y(K,I)+.057
      GO TO 80
   13 DO 883 I=1,NC
  883 Y(K,I)=Y(K,I)-5.35
      GO TO 80
   80 CONTINUE
      RETURN
      END
      SUBROUTINE DESACF(N,DATA,VALUE,AMEAN,STD,MSPEC)
C==================================================================
C==================================================================
C THIS SUBROUTINE GIVES THE MEAN, VARIANCE(DIVIDE BY N),
C STANDARD DEVIATION, MAXIMUM, MINIMUM, AND RANGE OF THE DATA.
C AUTOCOVARIANCE FUNCTION AND AUTOCORRELATION FUNCTION ARE ALSO
C CALCULATED. CORRELOGRAM IS PLOTTED WITH CONFIDENCE LIMITS, AND
C THE NUMBER OF LAGS= NUMBER OF DATA/4.
C VARIABLE NAMES:
C N: NUMBER OF DATA
C DATA: INPUT DATA
C VALUE: IS BETWEEN 0 AND 1. IT DETERMINES THE CONFIDENCE LIMITS
C        IN THE CORRELOGRAM
C OUTPUT:
C   MSPEC=-1 MEANS SPECTRUM NOT CALCULATED
C          0 MEANS CUTTING POINT OF C(K) USED IN SPECTRUM
C          CALCUALTION IS DETERMINED BY AUTOMATED METHOD
C
C          THE METHOD:
C          THE LEAST NUMBER AFTER WHICH 5 CONSECUTIVE A.C.F. ARE
C          LESSER THAN A SMALL NUMBER IN ASOLUTE MAGNITUDE(.02)
C          THIS LEAST NUMBER  IS THEN ASSIGNED TO M
C     ANY+INTEGER: THIS IS USED DIRECTLY AS OUR LAST A.C.V. IN
C                  CALCULATING THE SPECTRUM
C===================================================================
C===================================================================
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 VALUE,AMEAN,STD
      REAL*8 DATA(1),SPDIF(300),ACOVF(300),ACORF(300)
      INTEGER P,CRVAL,PACF,C
      REAL*8 T,SQUAD,SCUBE,SUM,SS,SSQ,A,AA,DMEAN,B1,BB,AKURT
      DIMENSION STAR(100),PLOT(121)
      DATA ONE/'I'/,B/' '/,S/'*'/
      DATA PLOT/60*' ','+',60*' '/
C     DATA STAR/100*'*'/,ONE/'I'/,B/' '/,S/'*'/,PLOT/60*' ','+',60*' '/
C     DE C VOOR BOVENSTAANDE REGEL VERWIJDERD EN LAATSTE DEEL GESPLITST,
C     MARTIN KNOTTERS 21-11-1996
C
      N1=MIN0(N,2000)
C      WRITE(9,900) (DATA(I),I=1,N1)
C  900 FORMAT(' ',7F10.4)
C      WRITE(8,950)(DATA(I),I=1,N1)
C  950 format(f12.2)
      DMEAN=.0
      VAR=.0
      SKEW=.0
      AKURT=.0
      DO 1 I=1,N
    1 DMEAN=DATA(I)+DMEAN
      DMEAN=DMEAN/N
      DO 2 I=1,N
      T1=DATA(I)-DMEAN
      T2=T1*T1
      VAR=VAR+T2
      T3=T2*T1
      SKEW=SKEW+T3
      T4=T3*T1
    2 AKURT=AKURT+T4
      VAR=VAR/N
      STD=SQRT(VAR)
      SKEW=SKEW/(N*STD*VAR)
      AKURT=AKURT/(N*VAR*VAR)-3.
      AMEAN=DMEAN
      AMAX=DATA(1)
      AMIN=DATA(1)
      DO 11 I=1,N
      IF(DATA(I) .GT. AMAX) AMAX=DATA(I)
   11 IF(DATA(I) .LT. AMIN) AMIN=DATA(I)
      RANGE=AMAX-AMIN
      N4=N/4
      N4=MIN0(N4,100)
      DO 13 J=1,N4
      SPDIF(J)=0.
      NJ=N-J
      DO 12 I=1,NJ
   12 SPDIF(J)=(DATA(I)-DMEAN)*(DATA(I+J)-DMEAN)+SPDIF(J)
      JR=N4+1-J
      ACOVF(J)=SPDIF(J)/N
      ACORF(J)=ACOVF(J)/VAR
   13 CONTINUE
      DO 14 J=1,N4
      JR=N4+1-J
      ACOVF(JR+1)=ACOVF(JR)
   14 ACORF(JR+1)=ACORF(JR)
      ACOVF(1)=VAR
      ACORF(1)=1.0
      N4=N4+1
C            WRITE(9,23) DMEAN,VAR,STD,SKEW,AKURT,AMAX,AMIN,RANGE
C   23 FORMAT(1H1,2X,'MEAN = ',F10.4,5X,'VARIANCE (N) = ',F12.0,
C     *       5X,'STANDARD DEVIATION = ',F10.4/
C     *      2X,'SKEWNESS = ',F10.4,5X,'KURTOSIS = ',F10.4/
C     *      2X,'MAXIMUM = ',F10.4,5X,'MINIMUM = ',F10.4,5X,
C     *      'RANGE = ',F10.4)
C      WRITE(9,100)
C  100 FORMAT(1H1/10X,'AUTOCOVARIANCE FUNCTION : '//)
C      WRITE(9,24) (ACOVF(J),J=1,N4)
C   24 FORMAT(/(1X,10F10.4))
C      WRITE(9,101)
C  101 FORMAT(/10X,'AUTOCORRELATION FUNCTION : '//)
C      WRITE(9,25) (ACORF(J),J=1,N4)
C   25 FORMAT(/(1X,10F7.4))
C      CRVAL=60*VALUE
C      WRITE(9,333)
C  333 FORMAT(1H1,2X,'-1.0',25X,'-0.5',25X,'0.0',25X,'0.5',25X,'1.0'/
C     *2X,20('+-----'),'+')
c      DO 300 I=1,N4
c     PACF=ACORF(I)*60
c      IF(PACF .GT. 0) GOTO 301
c      IF(PACF .LT. 0) GOTO 304
c      GOTO 303
c  304 C=61+PACF
c      DO 305 K=C,60
c  305 PLOT(K)=S
c      GOTO 303
c  301 DO 302 J=1,PACF
c      J1=J+61
c  302 PLOT(J1)=S
c  303 M=61-CRVAL
c      MM=61+CRVAL
c      IF(PLOT(M) .EQ. B) PLOT(M)=ONE
c      IF(PLOT(MM) .EQ. B) PLOT(MM)=ONE
C      WRITE(9,306) (PLOT(L),L=1,121)
C  306 FORMAT(2X,121A1)
c      DO 307 II=1,60
c      PLOT(II)=B
c      II1=II+61
c  307 PLOT(II1)=B
c  300 CONTINUE
c      IF(VALUE .EQ. 1.0) GOTO 4
C      WRITE(9,400) VALUE,N
C  400 FORMAT(////'  CRITICAL VALUE = ',F10.4, ' I.E. 1.96/(',
C     1'SQRT(',I5,'))')
c    4 IF(MSPEC .LT.0) RETURN
C     IF(MSPEC .GT. 0) GOTO 3
C     CALL CUTPT(ACORF,N4+1,MSPEC)
C     WRITE(9,901)N4,MSPEC
C 901 FORMAT(' N4 MSPEC =',2I5)
C     GOTO 3
C   3 CALL SPECM(ACOVF,MSPEC,1)
      RETURN
      END
      SUBROUTINE COMBI(NRCAS,MKY,NRM)
C==============================================================
C==============================================================
C     Makes combinations of AR-cases of X and Y, for NREG regimes.
C==============================================================
C==============================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION NCASE(1200,2),NRCAS(160000,10)
      I3=1
      DO 100 I1=1,NRM
         DO 101 I2=1,NRM
            NCASE(I3,1)=I1
            NCASE(I3,2)=I2
            I3=I3+1
  101    CONTINUE
  100 CONTINUE
      NUCA=NRM**2
      JJ3=1
      DO 200 J1=1,NUCA
            NRCAS(JJ3,1)=NCASE(J1,1)
            NRCAS(JJ3,2)=NCASE(J1,2)
  205       JJ3=JJ3+1
  200   CONTINUE
        RETURN
        END
      SUBROUTINE COMBIX(NRCAS,MKY,NRM)
C==============================================================
C==============================================================
C     Makes combinations of AR-cases of X, for NREG regimes.
C==============================================================
C==============================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION NCASE(400,2),NRCAS(160000,10)
      I3=1
      DO 100 I1=1,NRM
            NCASE(I3,1)=I1
            I3=I3+1
  101    CONTINUE
  100 CONTINUE
      NUCA=NRM
      JJ3=1
      DO 200 J1=1,NUCA
            NRCAS(JJ3,1)=NCASE(J1,1)
  205       JJ3=JJ3+1
  200   CONTINUE
        RETURN
        END
c#####################################################
c Quicksort routine from numerical recipes
c#####################################################
      SUBROUTINE QCKSRT(N,ARR)
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (M=7,NSTACK=50,FM=7875.,FA=211.,FC=1663.
     *    ,FMI=1.2698413E-4,maxdat=20000)
      DIMENSION ISTACK(NSTACK)
      DIMENSION ARR(maxdat)
      JSTACK=0
      L=1
      IR=N
      FX=0.
10    IF(IR-L.LT.M)THEN
        DO 13 J=L+1,IR
          A=ARR(J)
          DO 11 I=J-1,1,-1
            IF(ARR(I).LE.A)GO TO 12
            ARR(I+1)=ARR(I)
11        CONTINUE
          I=0
12        ARR(I+1)=A
13      CONTINUE
        IF(JSTACK.EQ.0)RETURN
        IR=ISTACK(JSTACK)
        L=ISTACK(JSTACK-1)
        JSTACK=JSTACK-2
      ELSE
        I=L
        J=IR
        FX=MOD(FX*FA+FC,FM)
        IQ=L+(IR-L+1)*(FX*FMI)
        A=ARR(IQ)
        ARR(IQ)=ARR(L)
20      CONTINUE
21        IF(J.GT.0)THEN
            IF(A.LT.ARR(J))THEN
              J=J-1
              GO TO 21
            ENDIF
          ENDIF
          IF(J.LE.I)THEN
            ARR(I)=A
            GO TO 30
          ENDIF
          ARR(I)=ARR(J)
          I=I+1
22        IF(I.LE.N)THEN
            IF(A.GT.ARR(I))THEN
              I=I+1
              GO TO 22
            ENDIF
          ENDIF
          IF(J.LE.I)THEN
            ARR(J)=A
            I=J
            GO TO 30
          ENDIF
          ARR(J)=ARR(I)
          J=J-1
        GO TO 20
30      JSTACK=JSTACK+2
        IF(JSTACK.GT.NSTACK)PAUSE 'NSTACK must be made larger.'
        IF(IR-I.GE.I-L)THEN
          ISTACK(JSTACK)=IR
          ISTACK(JSTACK-1)=I+1
          IR=I-1
        ELSE
          ISTACK(JSTACK)=I-1
          ISTACK(JSTACK-1)=L
          L=I+1
        ENDIF
      ENDIF
      GO TO 10
      END
      SUBROUTINE PCAND(X,N,CTHD,IPL,IPU,STEP)
C==============================================================
C==============================================================
C Martin Knotters, May 1997.
C Defines candidate threshold values for water-table depths.
C The threshold values are at intervals of 1 cm in a
C user-supplied interpercentile range. 
C X : the matrix of data;
C N : the number of data;
C CTHD : the matrix of candidate threshold values;
C IPL : the user-supplied lower percentile;
C IPU : the user-supplied upper percentile.
C Subroutine called: QCKSRT.
C==============================================================
C==============================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 IPL,IPU
      DIMENSION X(2,1000),CTHD(2,300),SARR(1000)
      DO I=1,N
          SARR(I)=X(1,I)
      ENDDO
      CALL QCKSRT(N,SARR)
      IP=NINT(IPL*N)
      AMIN=SARR(IP)
      IP=NINT(IPU*N)
      AMAX=SARR(IP)
C      I=INT(AMAX-AMIN)
      I=INT((AMAX-AMIN)/STEP)
      DO 12 K=1,2
C         CTHD(K,1)=REAL(INT(AMIN))
         CTHD(K,1)=AMIN
         DO 13 J=2,I
c            CTHD(K,J)=CTHD(K,J-1)+1
            CTHD(K,J)=CTHD(K,J-1)+STEP
      Print*,cthd(k,j)
   13    CONTINUE
   12 CONTINUE
      RETURN
      END
      
